<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile Claim
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Claim</sch:title>
    <sch:rule context="f:Claim">
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/patient-cohort']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/patient-cohort': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/claimant-number']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/claimant-number': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/originating-claimant-number']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/originating-claimant-number': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:supportingInfo) &gt;= 1">supportingInfo: minimum cardinality of 'supportingInfo' is 1</sch:assert>
      <sch:assert test="count(f:insurance) &lt;= 1">insurance: maximum cardinality of 'insurance' is 1</sch:assert>
      <sch:assert test="count(f:item) &gt;= 1">item: minimum cardinality of 'item' is 1</sch:assert>
      <sch:assert test="count(f:total) &gt;= 1">total: minimum cardinality of 'total' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Claim/f:item</sch:title>
    <sch:rule context="f:Claim/f:item">
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/patient-flag']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/patient-flag': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/prescriber-flag']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/prescriber-flag': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/prescription-flag']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/prescription-flag': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/dose-flag']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/dose-flag': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/group-id']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/group-id': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:detail) &gt;= 1">detail: minimum cardinality of 'detail' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Claim/f:item/f:detail</sch:title>
    <sch:rule context="f:Claim/f:item/f:detail">
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/hsaap-balance-owing']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/hsaap-balance-owing': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/wastageQuantity']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/wastageQuantity': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/cbsSubsidy']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/cbsSubsidy': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/cbsPackSize']) &lt;= 1">extension with URL = 'https://fhir-ig.digital.health.nz/shared-care/StructureDefinition/cbsPackSize': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:quantity) &gt;= 1">quantity: minimum cardinality of 'quantity' is 1</sch:assert>
      <sch:assert test="count(f:net) &gt;= 1">net: minimum cardinality of 'net' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
